/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.green.Bite_Green;
import com.megacrit.cardcrawl.cards.green.Strike_Green;
import com.megacrit.cardcrawl.cards.red.Bite_Red;
import com.megacrit.cardcrawl.cards.red.Strike_Red;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.relics.BloodVial;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Vampires
extends AbstractImageEvent {
    private static final Logger logger = LogManager.getLogger(Vampires.class.getName());
    public static final String ID = "Vampires";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Vampires");
    public static final String NAME = Vampires.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = Vampires.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = Vampires.eventStrings.OPTIONS;
    private static final String INTRO_BODY_M = DESCRIPTIONS[0];
    private static final String INTRO_BODY_F = DESCRIPTIONS[1];
    private static final String ACCEPT_BODY = DESCRIPTIONS[2];
    private static final String EXIT_BODY = DESCRIPTIONS[3];
    private static final String GIVE_VIAL = DESCRIPTIONS[4];
    private static final int HP_DRAIN_PERCENT = 30;
    private static final float HP_PERCENT = 0.7f;
    private int screenNum = 0;
    private boolean hasVial = false;

    public Vampires() {
        super(NAME, "test", "images/events/vampires.jpg");
        this.body = AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.THE_SILENT ? INTRO_BODY_F : INTRO_BODY_M;
        this.hasVial = AbstractDungeon.player.hasRelic("Blood Vial");
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                GenericEventDialog.setDialogOption(OPTIONS[0] + 30 + OPTIONS[1], new Bite_Red());
                if (!this.hasVial) break;
                String vialName = new BloodVial().name;
                GenericEventDialog.setDialogOption(OPTIONS[3] + vialName + OPTIONS[4], new Bite_Red());
                break;
            }
            case THE_SILENT: {
                GenericEventDialog.setDialogOption(OPTIONS[0] + 30 + OPTIONS[1], new Bite_Green());
                if (!this.hasVial) break;
                String vialName = new BloodVial().name;
                GenericEventDialog.setDialogOption(OPTIONS[3] + vialName + OPTIONS[4], new Bite_Green());
                break;
            }
        }
        GenericEventDialog.setDialogOption(OPTIONS[2]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.updateBodyText(ACCEPT_BODY);
                        AbstractDungeon.player.maxHealth = (int)((float)AbstractDungeon.player.maxHealth * 0.7f);
                        this.logMetric("Became a vampire");
                        if (AbstractDungeon.player.currentHealth > AbstractDungeon.player.maxHealth) {
                            AbstractDungeon.player.currentHealth = AbstractDungeon.player.maxHealth;
                        }
                        this.replaceAttacks();
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[5]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                    case 1: {
                        if (!this.hasVial) break;
                        GenericEventDialog.updateBodyText(GIVE_VIAL);
                        this.logMetric("Became a vampire (Vial)");
                        AbstractDungeon.player.loseRelic("Blood Vial");
                        this.replaceAttacks();
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[5]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                }
                this.logMetric("Ignored");
                GenericEventDialog.updateBodyText(EXIT_BODY);
                this.screenNum = 2;
                GenericEventDialog.updateDialogOption(0, OPTIONS[5]);
                GenericEventDialog.clearRemainingOptions();
                break;
            }
            case 1: {
                this.openMap();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    private void replaceAttacks() {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                Iterator<AbstractCard> i = AbstractDungeon.player.masterDeck.group.iterator();
                while (i.hasNext()) {
                    AbstractCard e = i.next();
                    if (!(e instanceof Strike_Red)) continue;
                    i.remove();
                }
                for (int i2 = 0; i2 < 5; ++i2) {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Bite_Red(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                    UnlockTracker.markCardAsSeen("Bite_R");
                }
                break;
            }
            case THE_SILENT: {
                Iterator<AbstractCard> i = AbstractDungeon.player.masterDeck.group.iterator();
                while (i.hasNext()) {
                    AbstractCard e = i.next();
                    if (!(e instanceof Strike_Green)) continue;
                    i.remove();
                }
                for (int i3 = 0; i3 < 5; ++i3) {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Bite_Green(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                    UnlockTracker.markCardAsSeen("Bite_G");
                }
                break;
            }
            case CROWBOT: {
                break;
            }
            default: {
                logger.info("UNSPECIFIED CLASS: " + AbstractDungeon.player.chosenClass.name());
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

